/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.io.IOException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.cert.OcspPolicy;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CertHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OcspPolicy.class);

    static Optional<X509Certificate> findTrustAnchorCert(X509Certificate cert, Set<TrustAnchor> trust) throws SignatureException {
        return CertHelper.findTrustAnchor(cert, trust).map(TrustAnchor::getTrustedCert);
    }

    static Optional<TrustAnchor> findTrustAnchor(X509Certificate cert, Set<TrustAnchor> trustAnchors) throws SignatureException {
        X509CertSelector certSelectX509 = new X509CertSelector();
        X500Principal certIssuer = cert.getIssuerX500Principal();
        try {
            certSelectX509.setSubject(certIssuer.getEncoded());
        }
        catch (IOException ex) {
            throw new SignatureException("Cannot set subject search criteria for trust anchor.", ex);
        }
        Throwable certVerificationFailure = null;
        for (TrustAnchor trusted : trustAnchors) {
            X500Principal caName;
            PublicKey trustPublicKey = null;
            if (trusted.getTrustedCert() != null) {
                if (certSelectX509.match(trusted.getTrustedCert())) {
                    trustPublicKey = trusted.getTrustedCert().getPublicKey();
                }
            } else if (trusted.getCA() != null && trusted.getCAPublicKey() != null && certIssuer.equals(caName = trusted.getCA())) {
                trustPublicKey = trusted.getCAPublicKey();
            }
            if (trustPublicKey == null) continue;
            try {
                cert.verify(trustPublicKey);
                return Optional.of(trusted);
            }
            catch (Exception ex) {
                if (certVerificationFailure == null) {
                    certVerificationFailure = new SignatureException("TrustAnchor found, but certificate validation for " + DigipostSecurity.describe(cert) + " failed", ex);
                    continue;
                }
                certVerificationFailure.addSuppressed(ex);
            }
        }
        if (certVerificationFailure != null) {
            throw certVerificationFailure;
        }
        return Optional.empty();
    }

    static Stream<String> getOrganizationUnits(X509Certificate cert) {
        JcaX509CertificateHolder bouncyCastleX509cert;
        try {
            bouncyCastleX509cert = new JcaX509CertificateHolder(cert);
        }
        catch (CertificateEncodingException e) {
            LOG.warn("Unable to resolve organizational units (OU=xyz) from " + DigipostSecurity.describe(cert) + ", because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", (Throwable)e);
            return Stream.empty();
        }
        return Stream.of(bouncyCastleX509cert.getSubject().getRDNs(BCStyle.OU)).map(RDN::getTypesAndValues).flatMap(Stream::of).map(AttributeTypeAndValue::getValue).map(IETFUtils::valueToString);
    }

    private CertHelper() {
    }
}

