/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.util.function.Predicate;
import no.digipost.security.cert.OcspDecision;
import no.digipost.security.cert.TrustedCertificateAndIssuer;

@FunctionalInterface
public interface OcspPolicy {
    public static final OcspPolicy ALWAYS_DO_OCSP_LOOKUP = OcspPolicy.always(OcspDecision.LOOKUP_OCSP);
    public static final OcspPolicy NEVER_DO_OCSP_LOOKUP = OcspPolicy.always(OcspDecision.SKIP_OCSP);
    public static final OcspPolicy ALWAYS_DO_OCSP_LOOKUP_EXCEPT_DIGIPOST_ISSUED = ALWAYS_DO_OCSP_LOOKUP.except(trusted -> trusted.isIssuedByDigipostCA() && !trusted.ocspLookupRequest.isPresent(), OcspDecision.SKIP_OCSP);

    public static OcspPolicy always(OcspDecision decision) {
        return trustedCertAndIssuer -> decision;
    }

    public OcspDecision decideFor(TrustedCertificateAndIssuer var1);

    default public OcspPolicy except(Predicate<TrustedCertificateAndIssuer> trustedCertEvaluator, OcspDecision decisionResult) {
        return trusted -> trustedCertEvaluator.test(trusted) ? decisionResult : this.decideFor(trusted);
    }
}

