/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.ocsp;

import java.io.IOException;
import java.net.URI;
import no.digipost.security.DigipostSecurityException;
import no.digipost.security.ocsp.OcspLookupRequest;
import no.digipost.security.ocsp.OcspResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;

public final class OcspLookup {
    public final URI uri;
    public final CertificateID certificateId;

    public OcspLookup(OcspLookupRequest request) {
        this(request.url, request.certificateId);
    }

    private OcspLookup(URI responderUri, CertificateID certificateId) {
        this.certificateId = certificateId;
        this.uri = responderUri;
    }

    public OcspResult executeUsing(CloseableHttpClient client) {
        try {
            ByteArrayEntity ocspRequestEntity = new ByteArrayEntity(new OCSPReqBuilder().addRequest(this.certificateId).build().getEncoded());
            HttpUriRequest ocspRequest = RequestBuilder.post((URI)this.uri).addHeader("Content-Type", "application/ocsp-request").setEntity((HttpEntity)ocspRequestEntity).build();
            return new OcspResult(this.uri, client.execute(ocspRequest));
        }
        catch (IOException | OCSPException e) {
            throw new DigipostSecurityException(e);
        }
    }

    public String toString() {
        return "OCSP-lookup to responder uri " + this.uri;
    }
}

