/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.ocsp;

import java.math.BigInteger;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Optional;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.ocsp.OcspUtils;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcspLookupRequest {
    static final Logger LOG = LoggerFactory.getLogger(OcspLookupRequest.class);
    public final URI url;
    public final BigInteger certificateSerialNumber;
    final CertificateID certificateId;
    private final String certificateDescription;

    public static Optional<OcspLookupRequest> tryCreate(X509Certificate certificate, X509Certificate issuer) {
        return OcspUtils.findOcspResponderUrl(certificate).flatMap(url -> OcspUtils.tryCreateCertificateId(certificate, issuer).map(id -> new OcspLookupRequest((URI)url, (CertificateID)id, DigipostSecurity.describe(certificate))));
    }

    private OcspLookupRequest(URI ocspResponderUrl, CertificateID certificateId, String certificateDescription) {
        this.url = ocspResponderUrl;
        this.certificateSerialNumber = certificateId.getSerialNumber();
        this.certificateId = certificateId;
        this.certificateDescription = certificateDescription + (certificateDescription.contains(String.valueOf(this.certificateSerialNumber)) ? "" : " (serial number " + this.certificateSerialNumber + ")");
    }

    public String toString() {
        return "OCSP-lookup request to " + this.url + " for " + this.certificateDescription;
    }
}

