/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.function;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import no.digipost.DiggExceptions;

@FunctionalInterface
public interface ThrowingSupplier<T, X extends Throwable> {
    public T get() throws X;

    default public Supplier<T> asUnchecked() {
        return this.ifExceptionGet(e -> {
            throw DiggExceptions.asUnchecked(e);
        });
    }

    default public Supplier<Optional<T>> ifException(Consumer<Exception> exceptionHandler) {
        return () -> Optional.ofNullable(this.ifExceptionGet(e -> {
            exceptionHandler.accept((Exception)e);
            return null;
        }).get());
    }

    default public Supplier<T> ifExceptionGet(Function<Exception, T> recoveryFunction) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                return recoveryFunction.apply(e);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw DiggExceptions.asUnchecked(e);
            }
        };
    }
}

