/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.util.function.Consumer;
import java.util.function.Function;
import no.digipost.DiggExceptions;
import no.digipost.function.ThrowingConsumer;
import no.digipost.function.ThrowingFunction;

public final class IO {
    public static <T extends AutoCloseable> Consumer<T> autoClosing(ThrowingConsumer<T, ? extends Exception> consumer) {
        return t1 -> IO.autoClosing((T t2) -> {
            consumer.accept(t2);
            return null;
        }).apply((AutoCloseable)t1);
    }

    public static <T extends AutoCloseable, R> Function<T, R> autoClosing(ThrowingFunction<T, R, ? extends Exception> function) {
        return closeable -> {
            try (AutoCloseable managed = closeable;){
                Object r = function.apply(managed);
                return r;
            }
            catch (Exception e) {
                throw DiggExceptions.asUnchecked(e);
            }
        };
    }

    private IO() {
    }
}

