/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import no.digipost.DiggCompare;

public final class TimeSpan
implements Comparable<TimeSpan>,
Serializable {
    public static final TimeSpan EMPTY_FAR_PAST = TimeSpan.from(Instant.MIN).lasting(Duration.ZERO);
    public final Instant start;
    public final Instant end;
    public final Duration duration;

    public static Started from(Instant start) {
        return new Started(start);
    }

    private TimeSpan(Instant start, Instant end, Duration duration) {
        this.start = start;
        this.end = end != null ? end : start.plus(duration);
        this.duration = duration != null ? duration : Duration.between(this.start, this.end);
    }

    public Stream<TimeSpan> collapse(TimeSpan other) {
        Optional<TimeSpan> intersection = this.intersection(other);
        if (intersection.isPresent()) {
            return Stream.of(TimeSpan.from(DiggCompare.min(this.start, other.start)).lasting(this.duration.plus(other.duration).minus(intersection.map(s -> s.duration).orElse(Duration.ZERO))));
        }
        return Stream.of(this, other).sorted();
    }

    public Optional<TimeSpan> intersection(TimeSpan other) {
        TimeSpan earliest = DiggCompare.min(this, other);
        TimeSpan latest = DiggCompare.max(this, other);
        if (earliest.includes(latest.start)) {
            if (earliest.covers(latest)) {
                return Optional.of(latest);
            }
            return Optional.of(TimeSpan.from(latest.start).until(DiggCompare.min(earliest.end, latest.end)));
        }
        return Optional.empty();
    }

    public boolean includes(Instant instant) {
        return instant.equals(this.start) || instant.isAfter(this.start) && instant.isBefore(this.end);
    }

    public boolean covers(TimeSpan other) {
        return !other.start.isBefore(this.start) && !other.end.isAfter(this.end);
    }

    @Override
    public int compareTo(TimeSpan other) {
        int comparison = this.start.compareTo(other.start);
        return comparison != 0 ? comparison : this.end.compareTo(other.end);
    }

    public boolean equals(Object o) {
        if (o instanceof TimeSpan) {
            TimeSpan other = (TimeSpan)o;
            return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return this.start + " to " + this.end + " (duration: " + this.duration + ")";
    }

    public static final class Started {
        public final Instant at;

        private Started(Instant at) {
            this.at = at;
        }

        public TimeSpan until(Instant endExclusively) {
            if (this.at.isAfter(endExclusively)) {
                throw new IllegalArgumentException("start instant " + this.at + " is after end instant " + endExclusively);
            }
            return new TimeSpan(this.at, endExclusively, null);
        }

        public TimeSpan lasting(Duration duration) {
            return new TimeSpan(this.at, null, duration);
        }
    }
}

