/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.io.Serializable;
import java.util.Objects;
import no.digipost.io.DataSizeUnit;

public final class DataSize
implements Serializable,
Comparable<DataSize> {
    private static final long serialVersionUID = 1L;
    public static final DataSize ZERO = new DataSize(0L);
    public static final DataSize MAX = new DataSize(Long.MAX_VALUE);
    private final long bytes;

    public static DataSize of(long value, DataSizeUnit unit) {
        if (value == 0L) {
            return ZERO;
        }
        if (unit.asBytes(value) == DataSize.MAX.bytes) {
            return MAX;
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Size can not be negative! (" + value + " " + (Object)((Object)unit) + ")");
        }
        return new DataSize(unit.asBytes(value));
    }

    public static DataSize bytes(long value) {
        return DataSize.of(value, DataSizeUnit.BYTES);
    }

    public static DataSize kB(long value) {
        return DataSize.of(value, DataSizeUnit.KILOBYTES);
    }

    public static DataSize MB(long value) {
        return DataSize.of(value, DataSizeUnit.MEGABYTES);
    }

    private DataSize(long bytes) {
        this.bytes = bytes;
    }

    public double get(DataSizeUnit unit) {
        return unit.fromBytes(this.bytes);
    }

    public long toBytes() {
        return this.bytes;
    }

    public String toString() {
        return String.format("%,d ", this.bytes) + (Object)((Object)DataSizeUnit.BYTES);
    }

    @Override
    public int compareTo(DataSize other) {
        return Long.compare(this.bytes, other.bytes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSize) {
            DataSize that = (DataSize)obj;
            return Objects.equals(this.bytes, that.bytes);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }
}

