/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import no.digipost.DiggExceptions;

public final class LimitedInputStream
extends FilterInputStream
implements Closeable {
    private final long sizeMax;
    private final Supplier<? extends Exception> throwIfTooManyBytes;
    private long count;

    public LimitedInputStream(InputStream inputStream, long maxBytesToRead, Supplier<? extends Exception> throwIfTooManyBytes) {
        super(inputStream);
        this.sizeMax = maxBytesToRead;
        this.throwIfTooManyBytes = throwIfTooManyBytes;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }

    private void checkLimit() throws IOException {
        if (this.count > this.sizeMax) {
            Exception tooManyBytes = this.throwIfTooManyBytes.get();
            if (tooManyBytes instanceof IOException) {
                throw (IOException)tooManyBytes;
            }
            throw DiggExceptions.asUnchecked(tooManyBytes);
        }
    }
}

