/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import no.digipost.DiggExceptions;
import no.digipost.function.ThrowingConsumer;
import no.digipost.function.ThrowingFunction;
import no.digipost.io.DataSize;
import no.digipost.io.LimitedInputStream;

public final class DiggIO {
    public static <T extends AutoCloseable> Consumer<T> autoClosing(ThrowingConsumer<T, ? extends Exception> consumer) {
        return t1 -> DiggIO.autoClosing((T t2) -> {
            consumer.accept(t2);
            return null;
        }).apply((AutoCloseable)t1);
    }

    public static <T extends AutoCloseable, R> Function<T, R> autoClosing(ThrowingFunction<T, R, ? extends Exception> function) {
        return closeable -> {
            try (AutoCloseable managed = closeable;){
                Object r = function.apply(managed);
                return r;
            }
            catch (Exception e) {
                throw DiggExceptions.asUnchecked(e);
            }
        };
    }

    public static InputStream limit(InputStream inputStream, DataSize maxDataToRead, Supplier<? extends Exception> throwIfTooManyBytes) {
        return new LimitedInputStream(inputStream, maxDataToRead, throwIfTooManyBytes);
    }

    private DiggIO() {
    }
}

