/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import no.digipost.DiggExceptions;
import no.digipost.io.DataSize;

public final class LimitedInputStream
extends FilterInputStream
implements Closeable {
    private final DataSize sizeMax;
    private final Supplier<? extends Exception> throwIfTooManyBytes;
    private long count;

    public LimitedInputStream(InputStream inputStream, DataSize maxDataToRead, Supplier<? extends Exception> throwIfTooManyBytes) {
        super(inputStream);
        this.sizeMax = maxDataToRead;
        this.throwIfTooManyBytes = throwIfTooManyBytes;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }

    private void checkLimit() throws IOException {
        if (this.count > this.sizeMax.toBytes()) {
            Exception tooManyBytes = this.throwIfTooManyBytes.get();
            if (tooManyBytes instanceof IOException) {
                throw (IOException)tooManyBytes;
            }
            throw DiggExceptions.asUnchecked(tooManyBytes);
        }
    }
}

