/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import no.digipost.concurrent.OneTimeAssignment;
import no.digipost.tuple.Tuple;
import no.digipost.tuple.ViewableAsTuple;

class MultitupleBuilder<T1, T2> {
    private final OneTimeAssignment<T1> firstElement = OneTimeAssignment.newInstance();
    private final ConcurrentLinkedDeque<T2> secondElements = new ConcurrentLinkedDeque();
    private final BiFunction<? super Tuple<T1, List<T2>>, ? super Tuple<T1, Optional<T2>>, ? extends RuntimeException> exceptionOnNonDistinctFirstElement;

    MultitupleBuilder(BiFunction<? super Tuple<T1, List<T2>>, ? super Tuple<T1, Optional<T2>>, ? extends RuntimeException> exceptionOnNonDistinctFirstElement) {
        this.exceptionOnNonDistinctFirstElement = exceptionOnNonDistinctFirstElement;
    }

    void tryAccumulate(ViewableAsTuple<T1, Optional<T2>> hasTuple) {
        Tuple<T1, Optional<T2>> tuple;
        block2: {
            tuple = hasTuple.asTuple();
            try {
                this.firstElement.set(tuple.first());
            }
            catch (OneTimeAssignment.AlreadyAssigned e) {
                T1 assignedFirst = this.firstElement.get();
                if (Objects.equals(assignedFirst, tuple.first())) break block2;
                RuntimeException tooManyElements = this.exceptionOnNonDistinctFirstElement.apply(Tuple.of(assignedFirst, new ArrayList<T2>(this.secondElements)), tuple);
                tooManyElements.addSuppressed(e);
                throw tooManyElements;
            }
        }
        tuple.second().ifPresent(this.secondElements::add);
    }

    Optional<Tuple<T1, List<T2>>> build() {
        T1 first = this.firstElement.get();
        return first != null ? Optional.of(Tuple.of(first, new ArrayList<T2>(this.secondElements))) : Optional.empty();
    }
}

