/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public final class DiggMaps {
    public static <K, V> Stream<V> unMapToValues(Map<K, V> map, BiConsumer<? super V, ? super K> consumer) {
        return DiggMaps.unMap(map, (Map.Entry<K, V> entry) -> {
            consumer.accept((Object)entry.getValue(), (Object)entry.getKey());
            return entry.getValue();
        });
    }

    public static <K, V> Stream<K> unMapToKeys(Map<K, V> map, BiConsumer<? super K, ? super V> consumer) {
        return DiggMaps.unMap(map, (Map.Entry<K, V> entry) -> {
            consumer.accept((Object)entry.getKey(), (Object)entry.getValue());
            return entry.getKey();
        });
    }

    public static <K, V, R> Stream<R> unMap(Map<K, V> map, BiFunction<K, V, R> unmapper) {
        return map.entrySet().stream().map(entry -> unmapper.apply(entry.getKey(), entry.getValue()));
    }

    public static <K, V, R> Stream<R> unMap(Map<K, V> map, Function<Map.Entry<K, V>, R> unmapper) {
        return map.entrySet().stream().map(unmapper);
    }

    private DiggMaps() {
    }
}

