/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import no.digipost.DiggExceptions;
import no.digipost.io.DataSize;

public final class LimitedInputStream
extends FilterInputStream
implements Closeable {
    public static final Supplier<Exception> SILENTLY_EOF_ON_REACHING_LIMIT = new SilentlyEofWhenReachingLimit();
    private final DataSize limit;
    private final Supplier<? extends Exception> throwIfTooManyBytes;
    private long count;

    public LimitedInputStream(InputStream inputStream, DataSize maxDataToRead, Supplier<? extends Exception> throwIfTooManyBytes) {
        super(inputStream);
        this.limit = maxDataToRead;
        this.throwIfTooManyBytes = throwIfTooManyBytes;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            if (this.hasReachedLimit()) {
                return -1;
            }
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            if (this.hasReachedLimit()) {
                return -1;
            }
        }
        return res;
    }

    private boolean hasReachedLimit() throws IOException {
        if (this.count > this.limit.toBytes()) {
            if (this.throwIfTooManyBytes == SILENTLY_EOF_ON_REACHING_LIMIT) {
                return true;
            }
            Exception tooManyBytes = this.throwIfTooManyBytes.get();
            if (tooManyBytes instanceof IOException) {
                throw (IOException)tooManyBytes;
            }
            throw DiggExceptions.asUnchecked(tooManyBytes);
        }
        return false;
    }

    private static final class SilentlyEofWhenReachingLimit
    implements Supplier<Exception> {
        @Override
        public Exception get() {
            throw new UnsupportedOperationException("Should not call get() on instance of " + SilentlyEofWhenReachingLimit.class.getSimpleName() + ", this indicates a bug.");
        }

        private SilentlyEofWhenReachingLimit() {
        }
    }
}

