/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.digipost.concurrent.executor.ExternallyManagedExecutorService;

public class DiggConcurrent {
    private static final Logger LOG = Logger.getLogger(DiggConcurrent.class.getName());

    public static ExecutorService fixedThreadPool(int threadAmount, String name) {
        return Executors.newFixedThreadPool(threadAmount, DiggConcurrent.threadNamingFactory(name));
    }

    public static ExecutorService singleThreaded(String name) {
        return Executors.newSingleThreadExecutor(DiggConcurrent.threadNamingFactory(name));
    }

    public static ScheduledExecutorService scheduledSingleThreaded(String name) {
        return Executors.newSingleThreadScheduledExecutor(DiggConcurrent.threadNamingFactory(name));
    }

    public static ScheduledExecutorService scheduled(int threadAmount, String name) {
        return Executors.newScheduledThreadPool(threadAmount, DiggConcurrent.threadNamingFactory(name));
    }

    public static ThreadFactory threadNamingFactory(String threadBaseName) {
        return DiggConcurrent.threadNamingFactory((long threadNum) -> threadBaseName + "-" + threadNum);
    }

    public static ThreadFactory threadNamingFactory(LongFunction<String> threadName) {
        return DiggConcurrent.threadNamingFactory(threadName, Executors.defaultThreadFactory());
    }

    public static ThreadFactory threadNamingFactory(LongFunction<String> threadName, ThreadFactory backingFactory) {
        AtomicLong threadNum = new AtomicLong(0L);
        return r -> {
            Thread newThread = backingFactory.newThread(r);
            newThread.setName((String)threadName.apply(threadNum.incrementAndGet()));
            return newThread;
        };
    }

    public static ExecutorService externallyManaged(ExecutorService executor) {
        return new ExternallyManagedExecutorService(executor);
    }

    public static boolean isExternallyManaged(ExecutorService executor) {
        return executor instanceof ExternallyManagedExecutorService;
    }

    public static void ensureShutdown(ExecutorService executor, Duration timeoutBeforeForcefulShutdown) {
        DiggConcurrent.ensureShutdown(executor.getClass().getSimpleName(), executor, timeoutBeforeForcefulShutdown);
    }

    public static void ensureShutdown(String executorName, ExecutorService executor, Duration timeoutBeforeForcefulShutdown) {
        if (DiggConcurrent.isExternallyManaged(executor)) {
            LOG.info(() -> "Not shutting down " + executorName + " executor since it is an " + ExternallyManagedExecutorService.class.getSimpleName());
            return;
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(timeoutBeforeForcefulShutdown.toMillis(), TimeUnit.MILLISECONDS)) {
                LOG.info(() -> executorName + " executor is forcefully shut down as waiting for orderly termination took more than " + timeoutBeforeForcefulShutdown);
                executor.shutdownNow();
            } else {
                LOG.info(() -> executorName + " executor was orderly shut down within the timeout of " + timeoutBeforeForcefulShutdown.toMillis() + " ms");
            }
        }
        catch (InterruptedException e) {
            String logMessageTemplate = "Interrupted when waiting for termination of %s executor. %s: %s";
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, e, () -> String.format(logMessageTemplate, executorName, e.getClass().getSimpleName(), e.getMessage()));
            }
            LOG.info(() -> String.format(logMessageTemplate, executorName, e.getClass().getSimpleName(), e.getMessage()));
        }
    }

    private DiggConcurrent() {
    }
}

