/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util;

import no.digipost.DiggExceptions;
import no.digipost.function.ThrowingConsumer;

abstract class AutoCloseableAdapter<T, X extends Exception> {
    private final T managedObject;
    private final ThrowingConsumer<? super T, X> closeOperation;

    protected AutoCloseableAdapter(T managedObject, ThrowingConsumer<? super T, X> closeOperation) {
        this.managedObject = managedObject;
        this.closeOperation = closeOperation;
    }

    public T object() {
        return this.managedObject;
    }

    public void close() throws X {
        this.closeOperation.accept(this.managedObject);
        if (this.managedObject instanceof AutoCloseable) {
            DiggExceptions.runUnchecked(() -> ((AutoCloseable)this.managedObject).close());
        }
    }
}

