/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.time.Instant;
import java.time.ZoneId;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

final class ClockSnapshot {
    final Instant instant;
    final ZoneId zone;

    ClockSnapshot(Instant instant, ZoneId zone) {
        this.instant = instant;
        this.zone = zone;
    }

    void to(BiConsumer<Instant, ZoneId> operation) {
        operation.accept(this.instant, this.zone);
    }

    <T> T as(BiFunction<Instant, ZoneId, T> mappingFunction) {
        return mappingFunction.apply(this.instant, this.zone);
    }

    static interface ResolverForJavaClock
    extends Resolver {
        public Instant instant();

        public ZoneId getZone();

        @Override
        default public ClockSnapshot clockSnapshot() {
            return new ClockSnapshot(this.instant(), this.getZone());
        }
    }

    static interface Resolver {
        public ClockSnapshot clockSnapshot();
    }
}

