/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import no.digipost.function.ThrowingConsumer;
import no.digipost.function.ThrowingFunction;
import no.digipost.time.ClockSnapshot;
import no.digipost.time.TimeControllable;

public final class ControllableClock
extends Clock
implements TimeControllable,
ClockSnapshot.ResolverForJavaClock,
Serializable {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<Clock> delegate;

    public static ControllableClock freezedAt(LocalDateTime dateTime) {
        return ControllableClock.freezedAt(dateTime.atZone(ZoneId.systemDefault()));
    }

    public static ControllableClock freezedAt(ZonedDateTime dateTime) {
        return ControllableClock.freezedAt(dateTime.toInstant(), dateTime.getZone());
    }

    public static ControllableClock freezedAt(Instant instant) {
        return ControllableClock.freezedAt(instant, ZoneId.systemDefault());
    }

    public static ControllableClock freezedAt(Instant instant, ZoneId zone) {
        return ControllableClock.control(Clock.fixed(instant, zone));
    }

    public static ControllableClock control(Clock clock) {
        return new ControllableClock(clock);
    }

    private ControllableClock(Clock delegate) {
        this.delegate = new AtomicReference<Clock>(delegate);
    }

    @Override
    public ControllableClock withZone(ZoneId zone) {
        Clock currentDelegate = this.delegate.get();
        if (zone.equals(currentDelegate.getZone())) {
            return this;
        }
        return new ControllableClock(currentDelegate.withZone(zone));
    }

    @Override
    public Instant instant() {
        return this.delegate.get().instant();
    }

    @Override
    public ZoneId getZone() {
        return this.delegate.get().getZone();
    }

    public ZonedDateTime zonedDateTime() {
        return this.instant().atZone(this.getZone());
    }

    public LocalDateTime localDateTime() {
        return LocalDateTime.ofInstant(this.instant(), this.getZone());
    }

    public <X extends Exception> void doWithTimeAdjusted(Consumer<TimeControllable> adjustClock, ThrowingConsumer<Instant, X> action) throws X {
        this.getWithTimeAdjusted(adjustClock, time -> {
            action.accept((Instant)time);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, X extends Exception> T getWithTimeAdjusted(Consumer<TimeControllable> adjustClock, ThrowingFunction<Instant, T, X> resolveValue) throws X {
        Clock originalClock = this.delegate.get();
        try {
            adjustClock.accept(this);
            T t = resolveValue.apply(this.instant());
            return t;
        }
        finally {
            this.set(temporary -> originalClock);
        }
    }

    @Override
    public void set(UnaryOperator<Clock> createNewClock) {
        this.delegate.getAndUpdate(previous -> {
            Clock newClock = (Clock)createNewClock.apply((Clock)previous);
            if (this.equals(newClock)) {
                throw new IllegalArgumentException("Cycle detected! Tried to set " + this + " with same instance as itself!");
            }
            return newClock;
        });
    }

    public String toString() {
        return "Controllable " + this.delegate.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ControllableClock) {
            ControllableClock that = (ControllableClock)obj;
            return Objects.equals(this.delegate.get(), that.delegate.get());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate.get());
    }
}

