/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.function.UnaryOperator;
import no.digipost.time.ClockSnapshot;

public interface TimeControllable
extends ClockSnapshot.Resolver {
    public void set(UnaryOperator<Clock> var1);

    default public void timePasses(Duration amountOfTime) {
        this.set(previous -> Clock.offset(previous, amountOfTime));
    }

    default public void timePasses(TemporalAmount amountOfTime) {
        Duration duration = amountOfTime instanceof Duration ? (Duration)amountOfTime : this.clockSnapshot().as((instant, zone) -> Duration.between(instant, instant.atZone((ZoneId)zone).plus(amountOfTime)));
        this.timePasses(duration);
    }

    default public void freezeAt(Instant instant, ZoneId zone) {
        this.set(previous -> Clock.fixed(instant, zone));
    }

    default public void freezeAt(Instant instant) {
        this.freezeAt(instant, this.clockSnapshot().zone);
    }

    default public void freezeAt(ZonedDateTime zonedDateTime) {
        this.freezeAt(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    default public void freezeAt(OffsetDateTime offsetDateTime) {
        this.freezeAt(offsetDateTime.toInstant(), offsetDateTime.getOffset());
    }

    default public void freezeAt(LocalDateTime offsetDateTime) {
        this.freezeAt(offsetDateTime.atZone(this.clockSnapshot().zone));
    }

    default public void freeze() {
        this.clockSnapshot().to(this::freezeAt);
    }

    default public void setToSystemClock(ZoneId zoneId) {
        this.set(previous -> Clock.system(zoneId));
    }

    default public void setToSystemClock() {
        this.setToSystemClock(this.clockSnapshot().zone);
    }

    default public void set(Instant instant, ZoneId zone) {
        this.set(previous -> Clock.offset(previous, Duration.between(previous.instant(), instant)).withZone(zone));
    }

    default public void set(Instant instant) {
        this.set(instant, this.clockSnapshot().zone);
    }

    default public void set(ZonedDateTime zonedDateTime) {
        this.set(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    default public void set(OffsetDateTime offsetDateTime) {
        this.set(offsetDateTime.toInstant(), offsetDateTime.getOffset());
    }

    default public void set(LocalDateTime localDateTime) {
        this.set(localDateTime.atZone(this.clockSnapshot().zone));
    }
}

