/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public final class ConditionalTimer<T> {
    private final Clock clock;
    private final Predicate<T> condition;
    private final AtomicReference<Instant> conditionMet = new AtomicReference();

    public static WithCustomClockBuilder using(Clock clock) {
        return new WithCustomClockBuilder(clock);
    }

    public static <T> ConditionalTimer<T> timeWhen(Predicate<T> condition) {
        return ConditionalTimer.using(Clock.systemUTC()).timeWhen(condition);
    }

    private ConditionalTimer(Predicate<T> condition, Clock clock) {
        this.condition = condition;
        this.clock = clock;
    }

    public final void inspect(T value) {
        if (this.condition.test(value)) {
            this.conditionMet.compareAndSet(null, Instant.now(this.clock));
        } else {
            this.conditionMet.set(null);
        }
    }

    public Optional<Duration> getDuration() {
        return Optional.ofNullable(this.conditionMet.get()).map(whenMet -> Duration.between(whenMet, Instant.now(this.clock)));
    }

    public boolean longerThan(Duration threshold) {
        return this.getDuration().filter(duration -> duration.toMillis() > threshold.toMillis()).isPresent();
    }

    public boolean sameOrlessThan(Duration threshold) {
        return !this.longerThan(threshold);
    }

    public static final class WithCustomClockBuilder {
        private final Clock clock;

        private WithCustomClockBuilder(Clock clock) {
            this.clock = clock;
        }

        public <T> ConditionalTimer<T> timeWhen(Predicate<T> condition) {
            return new ConditionalTimer(condition, this.clock);
        }
    }
}

