/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class DiggBase {
    public static <T> T nonNull(String description, T t) {
        return (T)DiggBase.nonNull(description, (? super String d) -> t);
    }

    public static <T, X extends Throwable> T nonNull(String description, T t, Function<? super String, X> throwIfNull) throws X {
        return DiggBase.nonNull(t, () -> (Throwable)throwIfNull.apply(description + " can not be null"));
    }

    public static <T, X extends Throwable> T nonNull(T t, Supplier<X> throwIfNull) throws X {
        return (T)DiggBase.nonNull("a reference", s -> t, (? super String s) -> (Throwable)throwIfNull.get());
    }

    public static <T> T nonNull(String descriptiveRefKey, Function<? super String, T> refResolver) {
        return DiggBase.nonNull(descriptiveRefKey, refResolver, (? super String d) -> new NullPointerException("Tried to resolve " + d + ", but got null!"));
    }

    public static <T, X extends Throwable> T nonNull(String descriptiveRefKey, Function<? super String, T> refResolver, Function<? super String, X> throwIfNull) throws X {
        T ref = refResolver.apply(descriptiveRefKey);
        if (ref != null) {
            return ref;
        }
        throw (Throwable)throwIfNull.apply(descriptiveRefKey);
    }

    @SafeVarargs
    public static final <T, R> Stream<R> extract(T object, Function<? super T, ? extends R> ... extractors) {
        return Stream.of(extractors).map(e -> e.apply(object));
    }

    @SafeVarargs
    public static final <T, R> Stream<R> extractIfPresent(T object, Function<? super T, ? extends Optional<R>> ... extractors) {
        return DiggBase.extract(object, extractors).filter(Optional::isPresent).map(Optional::get);
    }

    private DiggBase() {
    }
}

