/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class OneTimeAssignment<V> {
    private final AtomicReference<V> ref = new AtomicReference();
    private final Supplier<? extends V> defaultValue;

    public static final <V> OneTimeAssignment<V> defaultTo(V defaultValue) {
        return OneTimeAssignment.defaultTo(() -> defaultValue);
    }

    public static final <V> OneTimeAssignment<V> defaultTo(Supplier<? extends V> defaultValue) {
        return new OneTimeAssignment<V>(defaultValue);
    }

    public static final <V> OneTimeAssignment<V> newInstance() {
        return new OneTimeAssignment<Object>(() -> null);
    }

    private OneTimeAssignment(Supplier<? extends V> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void set(V value) {
        if (!this.ref.compareAndSet(null, value)) {
            throw new AlreadyAssigned(this.ref.get(), value);
        }
    }

    public V get() {
        return this.ref.updateAndGet(v -> v != null ? v : this.defaultValue.get());
    }

    public static final class AlreadyAssigned
    extends IllegalStateException {
        private AlreadyAssigned(Object alreadyAssignedValue, Object attemptedAssignedValue) {
            super("Already assigned to " + alreadyAssignedValue + ". Can not be reassigned to " + attemptedAssignedValue);
        }
    }
}

