/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import no.digipost.DiggExceptions;

public class ConsumingInputStream
extends InputStream {
    private final PipedInputStream inputPipe = new PipedInputStream();
    private final Future<?> producing;
    private final AtomicBoolean attemptToCloseInputStream = new AtomicBoolean(false);

    public ConsumingInputStream(ExecutorService executorService, Consumer<? super OutputStream> write) {
        this(executorService, o -> o, write);
    }

    public <S extends OutputStream> ConsumingInputStream(ExecutorService executorService, Function<OutputStream, S> outputStreamDecorator, Consumer<? super S> write) {
        OutputStream decoratedOutputPipe;
        PipedOutputStream outputPipe;
        try {
            outputPipe = new PipedOutputStream(this.inputPipe);
            decoratedOutputPipe = (OutputStream)outputStreamDecorator.apply(outputPipe);
        }
        catch (IOException e) {
            throw DiggExceptions.asUnchecked(e);
        }
        this.producing = executorService.submit(new Producer(this, outputPipe, decoratedOutputPipe, write));
    }

    @Override
    public int read() throws IOException {
        this.failIfProducerFailed();
        return this.inputPipe.read();
    }

    @Override
    public void close() throws IOException {
        try {
            this.failIfProducerFailed();
            this.attemptToCloseInputStream.set(true);
            if (!this.producing.isDone()) {
                this.producing.cancel(true);
            }
        }
        finally {
            this.inputPipe.close();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.failIfProducerFailed();
        return this.inputPipe.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.failIfProducerFailed();
        return this.inputPipe.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.failIfProducerFailed();
        return this.inputPipe.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.failIfProducerFailed();
        return this.inputPipe.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputPipe.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputPipe.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputPipe.markSupported();
    }

    private void failIfProducerFailed() {
        if (this.producing.isDone()) {
            try {
                this.producing.get();
            }
            catch (Exception e) {
                throw new ProducerFailed(e);
            }
        }
    }

    private static class Producer<S extends OutputStream>
    implements Runnable {
        final PipedOutputStream outputPipe;
        final S decoratedOutputPipe;
        final Consumer<? super S> write;
        final /* synthetic */ ConsumingInputStream this$0;

        Producer(PipedOutputStream outputPipe, S decoratedOutputPipe, Consumer<? super S> write) {
            this.this$0 = var1_1;
            this.outputPipe = outputPipe;
            this.decoratedOutputPipe = decoratedOutputPipe;
            this.write = write;
        }

        @Override
        public void run() {
            try {
                this.write.accept(this.decoratedOutputPipe);
            }
            catch (Exception e) {
                throw DiggExceptions.asUnchecked(e);
            }
            finally {
                try {
                    try {
                        ((OutputStream)this.decoratedOutputPipe).close();
                    }
                    finally {
                        this.outputPipe.close();
                    }
                }
                catch (IOException e) {
                    if (this.this$0.attemptToCloseInputStream.get()) {
                        return;
                    }
                    throw DiggExceptions.asUnchecked(e);
                }
            }
        }
    }

    public static final class ProducerFailed
    extends RuntimeException {
        private ProducerFailed(Throwable cause) {
            super("Tr\u00e5den som skriver data for lesing av ConsumingInputStream har feilet. Cause: " + cause.getClass() + ": " + cause.getMessage(), cause);
        }
    }
}

