/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import no.digipost.function.ThrowingRunnable;

public interface AtMostOne<T> {
    default public Optional<T> discardRemaining() {
        return this.orElse(() -> {});
    }

    default public Optional<T> get() {
        return this.orIfExcessiveThrow(TooManyElements::new);
    }

    default public <X extends Throwable> Optional<T> orIfExcessiveThrow(Supplier<X> exceptionSupplier) throws X {
        return this.orElse(() -> {
            throw (Throwable)exceptionSupplier.get();
        });
    }

    public <X extends Throwable> Optional<T> orElse(ThrowingRunnable<X> var1) throws X;

    public static <T> AtMostOne<T> from(Iterable<T> iterable) {
        return AtMostOne.from(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static <T> AtMostOne<T> from(Collection<T> list) {
        return AtMostOne.from(list.stream());
    }

    public static <T> AtMostOne<T> from(final Stream<T> stream) {
        return new AtMostOne<T>(){

            @Override
            public <X extends Throwable> Optional<T> orElse(ThrowingRunnable<X> handleUnexpectedMultipleElements) throws X {
                List possiblyTwoItems = stream.limit(2L).collect(Collectors.toList());
                int size = possiblyTwoItems.size();
                if (size == 0) {
                    return Optional.empty();
                }
                if (size > 1) {
                    handleUnexpectedMultipleElements.run();
                }
                return Optional.of(possiblyTwoItems.get(0));
            }
        };
    }

    public static final class TooManyElements
    extends RuntimeException {
        public TooManyElements() {
            super("exepcted at most one element, but there were excess ones");
        }
    }
}

