/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import no.digipost.function.ThrowingBiFunction;
import no.digipost.jdbc.ColumnMapper;

@FunctionalInterface
public interface BasicColumnMapper<R>
extends ColumnMapper<R> {
    public static <R> BasicColumnMapper<R> of(ThrowingBiFunction<String, ResultSet, R, ? extends SQLException> function) {
        return (name, rs) -> function.apply(name, rs);
    }

    default public <S> BasicColumnMapper<S> andThen(Function<? super R, S> mapper) {
        return (a, rs) -> mapper.apply((R)this.map(a, rs));
    }

    default public BasicColumnMapper<R> nullFallthrough() {
        final BasicColumnMapper parent = this;
        return new BasicColumnMapper<R>(){

            @Override
            public R map(String name, ResultSet resultSet) throws SQLException {
                return parent.map(name, resultSet);
            }

            @Override
            public <S> BasicColumnMapper<S> andThen(Function<? super R, S> mapper) {
                return (a, rs) -> {
                    Object maybeResult = this.map(a, rs);
                    return maybeResult != null ? mapper.apply((Object)maybeResult) : null;
                };
            }
        };
    }
}

