/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Function;
import no.digipost.function.ThrowingBiFunction;
import no.digipost.jdbc.ColumnMapper;

@FunctionalInterface
public interface NullableColumnMapper<R>
extends ColumnMapper<Optional<R>> {
    public static <R> NullableColumnMapper<R> of(ThrowingBiFunction<String, ResultSet, R, ? extends SQLException> function) {
        return (name, rs) -> function.andThen(Optional::ofNullable).apply(name, rs);
    }

    default public <S> NullableColumnMapper<S> andThen(Function<? super R, S> mapper) {
        return (name, rs) -> ((Optional)this.map(name, rs)).map(mapper);
    }
}

