/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class DiggCompare {
    public static <T extends Comparable<T>> T min(T t1, T t2) {
        return t1.compareTo(t2) > 0 ? t2 : t1;
    }

    public static <T extends Comparable<T>> T max(T t1, T t2) {
        return t2.compareTo(t1) > 0 ? t2 : t1;
    }

    public static <T> T minBy(Comparator<? super T> propertyComparator, T t1, T t2) {
        return propertyComparator.compare(t1, t2) > 0 ? t2 : t1;
    }

    public static <T, U extends Comparable<? super U>> T minBy(Function<? super T, U> propertyExtractor, T t1, T t2) {
        return DiggCompare.minBy(Comparator.comparing(propertyExtractor), t1, t2);
    }

    public static <T> T maxBy(Comparator<? super T> comparator, T t1, T t2) {
        return comparator.compare(t2, t1) > 0 ? t2 : t1;
    }

    public static <T, U extends Comparable<? super U>> T maxBy(Function<? super T, U> propertyExtractor, T t1, T t2) {
        return DiggCompare.maxBy(Comparator.comparing(propertyExtractor), t1, t2);
    }

    @SafeVarargs
    public static <T> Comparator<T> prioritize(T ... elementsOrderedByPriority) {
        return DiggCompare.prioritize(Arrays.asList(elementsOrderedByPriority));
    }

    public static <T> Comparator<T> prioritize(List<T> elementsOrderedByPriority) {
        return (t1, t2) -> {
            int firstIndex = elementsOrderedByPriority.indexOf(t1);
            int secondIndex = elementsOrderedByPriority.indexOf(t2);
            if (firstIndex < 0 && secondIndex >= 0) {
                return 1;
            }
            if (secondIndex < 0 && firstIndex >= 0) {
                return -1;
            }
            return Integer.compare(firstIndex, secondIndex);
        };
    }

    private DiggCompare() {
    }
}

