/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import no.digipost.util.ChainableAssignment;
import no.digipost.util.ViewableAsOptional;

public interface Assignment<V>
extends Supplier<V>,
Consumer<V>,
ViewableAsOptional.Single<V> {
    public static <V> Assignment<V> from(AtomicReference<V> reference) {
        return Assignment.from(reference, AtomicReference::get, AtomicReference::set);
    }

    public static <V, S> Assignment<V> from(final S container, final Function<? super S, V> getter, final BiConsumer<? super S, ? super V> setter) {
        return new Assignment<V>(){

            @Override
            public V get() {
                return getter.apply(container);
            }

            @Override
            public void set(V value) {
                setter.accept(container, value);
            }
        };
    }

    public void set(V var1);

    @Override
    default public void accept(V value) {
        this.set(value);
    }

    default public <C> ChainableAssignment<V, C> chainableWith(C chainReturnObject) {
        return new ChainableAssignment(this, chainReturnObject);
    }
}

