/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

public enum DataSizeUnit {
    BYTES(1, "bytes"),
    KILOBYTES(DataSizeUnit.BYTES.numberOfBytes * 1024, "kB"),
    MEGABYTES(DataSizeUnit.KILOBYTES.numberOfBytes * 1024, "MB"),
    GIGABYTES(DataSizeUnit.MEGABYTES.numberOfBytes * 1024, "GB");

    public static final DataSizeUnit B;
    public static final DataSizeUnit kB;
    public static final DataSizeUnit MB;
    public static final DataSizeUnit GB;
    private final int numberOfBytes;
    private final String symbol;

    private DataSizeUnit(int numberOfBytes, String symbol) {
        this.numberOfBytes = numberOfBytes;
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    long asBytes(long value) {
        return value * (long)this.numberOfBytes;
    }

    double fromBytes(long value) {
        return this == BYTES ? (double)value : (double)value / (double)this.numberOfBytes;
    }

    static {
        B = BYTES;
        kB = KILOBYTES;
        MB = MEGABYTES;
        GB = GIGABYTES;
    }
}

