/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import no.digipost.DiggExceptions;
import no.digipost.function.ThrowingConsumer;
import no.digipost.function.ThrowingFunction;
import no.digipost.io.DataSize;
import no.digipost.io.LimitedInputStream;

public final class DiggIO {
    public static <T extends AutoCloseable> Consumer<T> autoClosing(ThrowingConsumer<T, ? extends Exception> consumer) {
        return t1 -> DiggIO.autoClosing((T t2) -> {
            consumer.accept(t2);
            return null;
        }).apply((AutoCloseable)t1);
    }

    public static <T extends AutoCloseable, R> Function<T, R> autoClosing(ThrowingFunction<T, R, ? extends Exception> function) {
        return closeable -> {
            Object r;
            block8: {
                AutoCloseable managed = closeable;
                try {
                    r = function.apply(managed);
                    if (managed == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (managed != null) {
                            try {
                                managed.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw DiggExceptions.asUnchecked(e);
                    }
                }
                managed.close();
            }
            return r;
        };
    }

    public static InputStream limit(InputStream inputStream, DataSize maxDataToRead) {
        return new LimitedInputStream(inputStream, maxDataToRead, LimitedInputStream.SILENTLY_EOF_ON_REACHING_LIMIT);
    }

    public static InputStream limit(InputStream inputStream, DataSize maxDataToRead, Supplier<? extends Exception> throwIfTooManyBytes) {
        return new LimitedInputStream(inputStream, maxDataToRead, throwIfTooManyBytes);
    }

    private DiggIO() {
    }
}

