/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.Collection;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import no.digipost.function.ObjIntFunction;
import no.digipost.function.ObjLongFunction;

public final class DiggStreams {
    public static final <S, V> Stream<V> streamByIntIndex(S source, int endExclusive, ObjIntFunction<S, V> resolveValue) {
        return DiggStreams.streamByIndex(source, IntStream.range(0, endExclusive), resolveValue);
    }

    public static final <S, K, V> Stream<V> streamByIndex(S source, IntStream indexes, ObjIntFunction<S, V> resolveValue) {
        return indexes.mapToObj(index -> resolveValue.apply(source, index));
    }

    public static final <S, V> Stream<V> streamByLongIndex(S source, long endExclusive, ObjLongFunction<S, V> resolveValue) {
        return DiggStreams.streamByIndex(source, LongStream.range(0L, endExclusive), resolveValue);
    }

    public static final <S, K, V> Stream<V> streamByIndex(S source, LongStream indexes, ObjLongFunction<S, V> resolveValue) {
        return indexes.mapToObj(index -> resolveValue.apply(source, index));
    }

    public static final <S, K, V> Stream<V> streamByKey(S source, Stream<K> keys, BiFunction<S, K, V> resolveValue) {
        return keys.map(key -> resolveValue.apply(source, key));
    }

    public static <E> Stream<E> streamWhileNonEmpty(IntFunction<? extends Collection<E>> resolveCollection) {
        return DiggStreams.streamPages(resolveCollection, c -> !c.isEmpty()).flatMap(Collection::stream);
    }

    public static <P> Stream<P> streamPages(IntFunction<P> resolvePage, Predicate<? super P> includeWhile) {
        return DiggStreams.streamPages(0, resolvePage, includeWhile);
    }

    public static <P> Stream<P> streamPages(final int firstPageNum, final IntFunction<P> resolvePage, final Predicate<? super P> includeWhile) {
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<P>(Long.MAX_VALUE, 0){
            final AtomicInteger pageNum;
            {
                super(arg0, arg1);
                this.pageNum = new AtomicInteger(firstPageNum);
            }

            @Override
            public boolean tryAdvance(Consumer<? super P> action) {
                Object nextPage = resolvePage.apply(this.pageNum.getAndIncrement());
                if (includeWhile.test(nextPage)) {
                    action.accept(nextPage);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    private DiggStreams() {
    }
}

