/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public final class DiggPredicates {
    public static <T> Predicate<T> nth(long n, Predicate<T> predicate) {
        if (n <= 0L) {
            throw new IllegalArgumentException(n + " is not a valid number for n. It must be 1 or greater");
        }
        AtomicLong foundMatches = new AtomicLong();
        return t -> predicate.test(t) && foundMatches.incrementAndGet() == n;
    }

    private DiggPredicates() {
    }
}

