/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import no.digipost.util.Assignment;

public final class OneTimeAssignment<V>
implements Assignment<V> {
    private final AtomicReference<Object> ref = new AtomicReference<Object>(UNASSIGNED);
    private final Supplier<?> defaultValue;
    private static final Object UNASSIGNED = new Object();

    public static final <V> OneTimeAssignment<V> defaultTo(V defaultValue) {
        return OneTimeAssignment.defaultTo(() -> defaultValue);
    }

    public static final <V> OneTimeAssignment<V> defaultTo(Supplier<? extends V> defaultValue) {
        return new OneTimeAssignment<V>(defaultValue);
    }

    public static final <V> OneTimeAssignment<V> newInstance() {
        return new OneTimeAssignment<V>(() -> UNASSIGNED);
    }

    private OneTimeAssignment(Supplier<?> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void set(V value) {
        if (!this.ref.compareAndSet(UNASSIGNED, value)) {
            throw new AlreadyAssigned(this.ref.get(), value);
        }
    }

    public boolean isSet() {
        return this.ref.get() != UNASSIGNED;
    }

    @Override
    public V get() {
        Object maybeAssigned = this.ref.updateAndGet(v -> v != UNASSIGNED ? v : this.defaultValue.get());
        return (V)(maybeAssigned != UNASSIGNED ? maybeAssigned : null);
    }

    public static final class AlreadyAssigned
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        private AlreadyAssigned(Object alreadyAssignedValue, Object attemptedAssignedValue) {
            super("Already assigned to " + alreadyAssignedValue + ". Can not be reassigned to " + attemptedAssignedValue);
        }
    }
}

