/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class CompletionHandler {
    public static final ConsumerBuilder<Object> doNothingOnSuccess = CompletionHandler.onSuccess(() -> {});

    public static <R> ConsumerBuilder<R> onSuccess(Runnable runOnSuccess) {
        return CompletionHandler.onSuccess((R result) -> runOnSuccess.run());
    }

    public static <R> ConsumerBuilder<R> onSuccess(Consumer<R> resultConsumer) {
        return new Builder<Object, Object>(result -> {
            resultConsumer.accept(result);
            return null;
        });
    }

    public static <R, U> FunctionBuilder<R, U> onSuccess(U successValue) {
        return CompletionHandler.onSuccess(() -> successValue);
    }

    public static <R, U> FunctionBuilder<R, U> onSuccess(Supplier<U> getOnSuccess) {
        return CompletionHandler.onSuccess((R result) -> getOnSuccess.get());
    }

    public static <R, U> FunctionBuilder<R, U> onSuccess(Function<R, U> resultMapper) {
        return new Builder<R, U>(resultMapper);
    }

    private CompletionHandler() {
    }

    private static class Builder<R, U>
    implements ConsumerBuilder<R>,
    FunctionBuilder<R, U> {
        private final Function<R, U> resultMapper;

        Builder(Function<R, U> function) {
            this.resultMapper = function;
        }

        @Override
        public <E extends Throwable> BiConsumer<R, E> orCatch(Consumer<E> exceptionConsumer) {
            return (result, thrown) -> this.orCatch((E t) -> {
                exceptionConsumer.accept(t);
                return null;
            }).apply((R)result, (Throwable)thrown);
        }

        @Override
        public <E extends Throwable> BiFunction<R, E, U> orCatch(Function<E, U> exceptionMapper) {
            return (result, thrown) -> thrown != null ? exceptionMapper.apply(thrown) : this.resultMapper.apply(result);
        }
    }

    public static interface FunctionBuilder<R, U> {
        public <E extends Throwable> BiFunction<R, E, U> orCatch(Function<E, U> var1);
    }

    public static interface ConsumerBuilder<R> {
        public <E extends Throwable> BiConsumer<R, E> orCatch(Consumer<E> var1);
    }
}

