/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import no.digipost.concurrent.TargetState;

public final class OneTimeToggle
implements TargetState {
    private final AtomicBoolean toggled = new AtomicBoolean(false);

    public void now() {
        this.toggled.set(true);
    }

    public <E extends Throwable> void nowOrIfAlreadyThenThrow(Supplier<E> exceptionSupplier) throws E {
        Throwable exceptionIfAlreadyToggled = (Throwable)this.toggleAndExecuteIfPreviouslyWas(true, exceptionSupplier);
        if (exceptionIfAlreadyToggled != null) {
            throw exceptionIfAlreadyToggled;
        }
    }

    @Override
    public boolean yet() {
        return this.toggled.get();
    }

    public void nowAndUnlessAlreadyToggled(Runnable action) {
        this.toggleAndExecuteIfPreviouslyWas(false, () -> {
            action.run();
            return null;
        });
    }

    public <T> Optional<T> nowAndUnlessAlreadyToggled(Supplier<T> supplier) {
        return Optional.ofNullable(this.toggleAndExecuteIfPreviouslyWas(false, supplier));
    }

    private <T> T toggleAndExecuteIfPreviouslyWas(boolean existing, Supplier<T> supplier) {
        if (this.toggled.getAndSet(true) == existing) {
            return supplier.get();
        }
        return null;
    }
}

