/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AdaptableCollector<T, A, R>
implements Collector<T, A, R> {
    private final Supplier<A> supplier;
    private final BiConsumer<A, T> accumulator;
    private final BinaryOperator<A> combiner;
    private final Function<A, R> finisher;
    private final Set<Collector.Characteristics> characteristics;

    public static <T, A, R> AdaptableCollector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
        return new AdaptableCollector<T, A, R>(supplier, accumulator, combiner, finisher, characteristics.stream());
    }

    public static <T, A, R> AdaptableCollector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Collector.Characteristics ... characteristics) {
        return new AdaptableCollector<T, A, R>(supplier, accumulator, combiner, finisher, Stream.of(characteristics));
    }

    private AdaptableCollector(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Stream<Collector.Characteristics> characteristics) {
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.finisher = finisher;
        this.characteristics = Collections.unmodifiableSet(characteristics.collect(Collectors.toSet()));
    }

    public <M> AdaptableCollector<T, A, M> andThen(Function<? super R, M> resultMapper) {
        return new AdaptableCollector<T, A, M>(this.supplier, this.accumulator, this.combiner, this.finisher.andThen(resultMapper), this.characteristics.stream().filter(c -> c != Collector.Characteristics.IDENTITY_FINISH));
    }

    @Override
    public Supplier<A> supplier() {
        return this.supplier;
    }

    @Override
    public BiConsumer<A, T> accumulator() {
        return this.accumulator;
    }

    @Override
    public BinaryOperator<A> combiner() {
        return this.combiner;
    }

    @Override
    public Function<A, R> finisher() {
        return this.finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.characteristics;
    }
}

