/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import no.digipost.util.GetsNamedValue;
import no.digipost.util.SetsNamedValue;

public final class Attribute<V>
implements GetsNamedValue<V>,
SetsNamedValue<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final String name;

    public Attribute(String name) {
        this.name = name;
    }

    @Override
    public void setOn(BiConsumer<String, ? super V> setter, V value) {
        setter.accept(this.name, value);
    }

    @Override
    public Optional<V> getFrom(Function<String, ?> getter) {
        Object attributeValue = getter.apply(this.name);
        return Optional.ofNullable(attributeValue);
    }

    public String toString() {
        return "attribute '" + this.name + "'";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attribute) {
            Attribute that = (Attribute)obj;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

