/*
 * Decompiled with CFR 0.152.
 */
package no.digipost;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import no.digipost.function.ThrowingBiConsumer;
import no.digipost.function.ThrowingBiFunction;
import no.digipost.function.ThrowingConsumer;
import no.digipost.function.ThrowingFunction;
import no.digipost.function.ThrowingRunnable;
import no.digipost.function.ThrowingSupplier;

public final class DiggExceptions {
    public static final Consumer<Exception> rethrowAnyException = DiggExceptions.rethrow(DiggExceptions::asUnchecked);

    public static Stream<Throwable> causalChainOf(Throwable t) {
        Stream.Builder<Throwable> causes = Stream.builder();
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            causes.add(cause);
        }
        return causes.build();
    }

    public static String exceptionNameAndMessage(Throwable t) {
        return t.getClass().getSimpleName() + ": '" + t.getMessage() + "'";
    }

    public static RuntimeException asUnchecked(Throwable t) {
        return DiggExceptions.asUnchecked(t, DiggExceptions::exceptionNameAndMessage);
    }

    public static <X extends Throwable> RuntimeException asUnchecked(X t, Function<? super X, String> message) {
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(message.apply(t), t);
    }

    public static <T, R> R applyUnchecked(ThrowingFunction<T, R, ? extends Throwable> function, T argument) {
        return function.asUnchecked().apply(argument);
    }

    public static <T> T getUnchecked(ThrowingSupplier<T, ? extends Throwable> supplier) {
        return supplier.asUnchecked().get();
    }

    public static void runUnchecked(ThrowingRunnable<? extends Throwable> runnable) {
        runnable.asUnchecked().run();
    }

    public static final <T, R, X extends Throwable> ThrowingFunction<T, R, X> mayThrow(ThrowingFunction<T, R, X> function) {
        return function;
    }

    public static final <T, U, R, X extends Throwable> ThrowingBiFunction<T, U, R, X> mayThrow(ThrowingBiFunction<T, U, R, X> bifunction) {
        return bifunction;
    }

    public static final <T, X extends Throwable> ThrowingSupplier<T, X> mayThrow(ThrowingSupplier<T, X> supplier) {
        return supplier;
    }

    public static final <T, X extends Throwable> ThrowingConsumer<T, X> mayThrow(ThrowingConsumer<T, X> consumer) {
        return consumer;
    }

    public static final <T, U, X extends Throwable> ThrowingBiConsumer<T, U, X> mayThrow(ThrowingBiConsumer<T, U, X> consumer) {
        return consumer;
    }

    public static final <T, X extends Throwable> ThrowingRunnable<X> mayThrow(ThrowingRunnable<X> runnable) {
        return runnable;
    }

    public static final <T extends Throwable> Consumer<T> rethrow(Function<T, ? extends RuntimeException> createUnchecked) {
        return e -> {
            throw (RuntimeException)createUnchecked.apply(e);
        };
    }

    private DiggExceptions() {
    }
}

