/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import no.digipost.collection.NonEmptyHeadTailList;
import no.digipost.stream.NonEmptyStream;

public interface NonEmptyList<E>
extends List<E> {
    public static <E> Optional<E> firstOf(List<E> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public static <E> NonEmptyList<E> of(E singleElement) {
        return new NonEmptyHeadTailList<E>(singleElement);
    }

    @SafeVarargs
    public static <E> NonEmptyList<E> of(E firstElement, E ... remainingElements) {
        return NonEmptyList.of(firstElement, Arrays.asList(remainingElements));
    }

    public static <E> NonEmptyList<E> of(E firstElement, List<E> remainingElements) {
        return new NonEmptyHeadTailList<E>(firstElement, remainingElements);
    }

    public static <E> Optional<NonEmptyList<E>> of(List<E> list) {
        return NonEmptyList.firstOf(list).map(first -> NonEmptyList.of(first, list.subList(1, list.size())));
    }

    public static <E> Optional<NonEmptyList<E>> of(E[] array) {
        return NonEmptyList.of(Arrays.asList(array));
    }

    public static <E> NonEmptyList<E> ofUnsafe(List<E> nonEmptyList) {
        return NonEmptyList.of(nonEmptyList).orElseThrow(() -> new IllegalArgumentException("empty list"));
    }

    public static <E> NonEmptyList<E> ofUnsafe(E[] nonEmptyArray) {
        return NonEmptyList.of(nonEmptyArray).orElseThrow(() -> new IllegalArgumentException("empty array"));
    }

    public static <E> Optional<NonEmptyList<E>> copyOf(List<E> list) {
        return NonEmptyList.firstOf(list).map(first -> NonEmptyList.of(first, new ArrayList(list.subList(1, list.size()))));
    }

    public static <E> Optional<NonEmptyList<E>> copyOf(E[] array) {
        return NonEmptyList.copyOf(Arrays.asList(array));
    }

    public static <E> NonEmptyList<E> copyOfUnsafe(List<E> nonEmptyList) {
        return NonEmptyList.copyOf(nonEmptyList).orElseThrow(() -> new IllegalArgumentException("empty list"));
    }

    public static <E> NonEmptyList<E> copyOfUnsafe(E[] nonEmptyArray) {
        return NonEmptyList.copyOf(nonEmptyArray).orElseThrow(() -> new IllegalArgumentException("empty array"));
    }

    @Override
    default public NonEmptyStream<E> stream() {
        return NonEmptyStream.of(this::first, this.subList(1, this.size()).stream());
    }

    default public E first() {
        return this.get(0);
    }

    @Override
    default public boolean isEmpty() {
        return false;
    }

    default public boolean isSingular() {
        return !this.hasMultipleElements();
    }

    default public boolean hasMultipleElements() {
        return this.size() > 1;
    }
}

