/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.function;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import no.digipost.DiggExceptions;

@FunctionalInterface
public interface ThrowingFunction<T, R, X extends Throwable> {
    public static <T> OfUncheckedException<T, T, RuntimeException> identity() {
        return t -> t;
    }

    public R apply(T var1) throws X;

    default public Function<T, R> asUnchecked() {
        return this.ifExceptionThrow((? super Exception e) -> DiggExceptions.asUnchecked(e));
    }

    default public Function<T, R> ifExceptionThrow(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        return this.ifExceptionThrow((? super T t, ? super Exception e) -> (RuntimeException)exceptionMapper.apply((Exception)e));
    }

    default public Function<T, R> ifExceptionThrow(BiFunction<? super T, ? super Exception, ? extends RuntimeException> exceptionMapper) {
        return this.ifException((? super T t, Exception e) -> {
            throw (RuntimeException)exceptionMapper.apply((Object)t, (Exception)e);
        }).andThen((? super R o) -> o.orElse(null));
    }

    default public Function<T, Optional<R>> ifException(Consumer<Exception> exceptionHandler) {
        return this.ifException((? super T t, Exception e) -> exceptionHandler.accept((Exception)e));
    }

    default public Function<T, Optional<R>> ifException(BiConsumer<? super T, Exception> exceptionHandler) {
        return t -> Optional.ofNullable(this.ifExceptionApply((? super T failingT, Exception e) -> {
            exceptionHandler.accept((Object)failingT, (Exception)e);
            return null;
        }).apply(t));
    }

    default public Function<T, R> ifExceptionApply(Function<Exception, ? extends R> exceptionMapper) {
        return this.ifExceptionApply((? super T t, Exception e) -> exceptionMapper.apply((Exception)e));
    }

    default public Function<T, R> ifExceptionApply(BiFunction<? super T, Exception, ? extends R> exceptionMapper) {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                return exceptionMapper.apply(t, e);
            }
            catch (Error err) {
                throw err;
            }
            catch (Throwable thr) {
                throw DiggExceptions.asUnchecked(thr);
            }
        };
    }

    default public <V> ThrowingFunction<T, V, X> andThen(ThrowingFunction<? super R, V, ? extends X> after) {
        return t -> after.apply((R)this.apply(t));
    }

    default public <V> ThrowingFunction<V, R, X> compose(ThrowingFunction<? super V, ? extends T, ? extends X> before) {
        return t -> this.apply(before.apply((Object)t));
    }

    @FunctionalInterface
    public static interface OfUncheckedException<T, R, X extends RuntimeException>
    extends ThrowingFunction<T, R, X>,
    Function<T, R> {
    }
}

