/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import no.digipost.jdbc.ColumnMapper;
import no.digipost.jdbc.RowMapper;
import no.digipost.tuple.Tuple;
import no.digipost.util.Attribute;

public final class AttributeMapper<R>
implements RowMapper<R> {
    private final Attribute<R> attribute;
    private final ColumnMapper<R> mapper;

    AttributeMapper(Attribute<R> attribute, ColumnMapper<R> mapper) {
        this.attribute = attribute;
        this.mapper = mapper;
    }

    @Override
    public R map(ResultSet resultSet) throws SQLException {
        return this.mapper.map(this.attribute.name, resultSet);
    }

    Tuple<Attribute<R>, R> attributeAndValue(ResultSet resultSet) throws SQLException {
        return this.attribute.withValue(this.map(resultSet));
    }

    String getAttributeName() {
        return this.attribute.name;
    }
}

