/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.util.bisect;

import no.digipost.util.bisect.Evaluator;
import no.digipost.util.bisect.Suggester;
import no.digipost.util.bisect.Suggestion;

public final class BisectSearch<T> {
    private final int min;
    private final int max;
    private final int maxAttempts;
    private final Suggester<T> suggester;

    public static <T> Builder<T> from(Suggester<T> suggester) {
        return new Builder(suggester);
    }

    private BisectSearch(int min, int max, int maxAttempts, Suggester<T> suggester) {
        this.min = min;
        this.max = max;
        this.maxAttempts = maxAttempts;
        this.suggester = suggester;
    }

    public BisectSearch<T> maximumAttempts(int maxAttempts) {
        return new BisectSearch<T>(this.min, this.max, maxAttempts, this.suggester);
    }

    public T searchFor(Evaluator<? super T> evaluator) {
        return BisectSearch.bisect(this.min, this.max, this.suggester, evaluator, this.maxAttempts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T bisect(int min, int max, Suggester<T> suggester, Evaluator<? super T> evaluator, int attempts) {
        Evaluator.Result result;
        if (attempts < 1) {
            throw new IllegalArgumentException("Must be allowed at least 1, but was only allowed " + attempts + " suggestion attempts");
        }
        int mid = (min + max) / 2;
        try (Suggestion<T> suggestion = suggester.suggest(mid);){
            if (mid == min || mid == max || attempts == 1) {
                T t = suggestion.accepted();
                return t;
            }
            try {
                result = evaluator.evaluate(suggestion.peek());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to evaluate suggested " + suggestion + ", created from bisection midpoint value " + mid + ", because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
            }
            if (result == Evaluator.Result.FOUND) {
                T t = suggestion.accepted();
                return t;
            }
        }
        catch (Exception e) {
            RuntimeException runtimeException;
            if (e instanceof RuntimeException) {
                runtimeException = (RuntimeException)e;
                throw runtimeException;
            }
            runtimeException = new RuntimeException("Unable to process suggestion from bisection midpoint value " + mid + ", because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
            throw runtimeException;
        }
        if (result != Evaluator.Result.TOO_HIGH) return BisectSearch.bisect(mid, max, suggester, evaluator, attempts - 1);
        return BisectSearch.bisect(min, mid, suggester, evaluator, attempts - 1);
    }

    public static final class Builder<T> {
        private static final int DEFAULT_MAX_ATTEMPTS = 20;
        private final Suggester<T> suggester;

        private Builder(Suggester<T> suggester) {
            this.suggester = suggester;
        }

        public BisectSearch<T> inRange(int min, int max) {
            if (min == max) {
                throw new IllegalArgumentException("min and max specifies an empty range of [" + min + "," + max + ")");
            }
            if (min > max) {
                throw new IllegalArgumentException("min " + min + " larger than max " + max);
            }
            return new BisectSearch(min, max, 20, this.suggester);
        }
    }
}

