/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.io;

import java.util.Iterator;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import no.digipost.collection.SimpleIterator;
import no.digipost.concurrent.OneTimeToggle;

public class Zip {
    public static Entries entriesIn(ZipInputStream zip) {
        return new Entries(zip);
    }

    private Zip() {
    }

    public static final class Entries
    implements Iterable<ZipEntry> {
        private final ZipInputStream zip;
        private final OneTimeToggle iteratorRequested = new OneTimeToggle();

        private Entries(ZipInputStream zip) {
            this.zip = zip;
        }

        @Override
        public Iterator<ZipEntry> iterator() {
            this.iteratorRequested.nowOrIfAlreadyThenThrow(() -> new IllegalStateException("Iterator can only be requested once!"));
            return new SimpleIterator<ZipEntry>(){

                @Override
                protected Optional<ZipEntry> nextIfAvailable() throws Exception {
                    return Optional.ofNullable(zip.getNextEntry());
                }
            };
        }
    }
}

