/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import no.digipost.time.ClockAdjuster;
import no.digipost.time.JavaClockAccessors;

interface JavaClockAdjuster
extends JavaClockAccessors,
ClockAdjuster {
    @Override
    default public void timePasses(Duration amountOfTime) {
        this.set(previous -> Clock.offset(previous, amountOfTime));
    }

    @Override
    default public void timePasses(TemporalAmount amountOfTime) {
        Duration duration;
        if (amountOfTime instanceof Duration) {
            duration = (Duration)amountOfTime;
        } else {
            Instant now = this.instant();
            duration = Duration.between(now, now.atZone(this.getZone()).plus(amountOfTime));
        }
        this.timePasses(duration);
    }

    @Override
    default public void freezeAt(Instant instant, ZoneId zone) {
        this.set(previous -> Clock.fixed(instant, zone));
    }

    @Override
    default public void freezeAt(Instant instant) {
        this.freezeAt(instant, this.getZone());
    }

    @Override
    default public void freezeAt(ZonedDateTime zonedDateTime) {
        this.freezeAt(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    @Override
    default public void freezeAt(OffsetDateTime offsetDateTime) {
        this.freezeAt(offsetDateTime.toInstant(), offsetDateTime.getOffset());
    }

    @Override
    default public void freezeAt(LocalDateTime offsetDateTime) {
        this.freezeAt(offsetDateTime.atZone(this.getZone()));
    }

    @Override
    default public void freeze() {
        this.freezeAt(this.instant(), this.getZone());
    }

    @Override
    default public void freezeTruncatedTo(TemporalUnit unit) {
        this.freezeAt(this.instant().truncatedTo(unit), this.getZone());
    }

    @Override
    default public void setToSystemClock(ZoneId zoneId) {
        this.set(previous -> Clock.system(zoneId));
    }

    @Override
    default public void setToSystemClock() {
        this.setToSystemClock(this.getZone());
    }

    @Override
    default public void set(Instant instant, ZoneId zone) {
        this.set(previous -> Clock.offset(previous, Duration.between(previous.instant(), instant)).withZone(zone));
    }

    @Override
    default public void set(Instant instant) {
        this.set(instant, this.getZone());
    }

    @Override
    default public void set(ZonedDateTime zonedDateTime) {
        this.set(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    @Override
    default public void set(OffsetDateTime offsetDateTime) {
        this.set(offsetDateTime.toInstant(), offsetDateTime.getOffset());
    }

    @Override
    default public void set(LocalDateTime localDateTime) {
        this.set(localDateTime.atZone(this.getZone()));
    }
}

