/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import no.digipost.collection.NonEmptyList;

final class NonEmptyHeadTailList<E>
extends AbstractList<E>
implements NonEmptyList<E> {
    private final E head;
    private final List<E> tail;

    NonEmptyHeadTailList(E singleElement) {
        this(singleElement, Collections.emptyList());
    }

    NonEmptyHeadTailList(E head, List<E> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public E get(int index) {
        return index == 0 ? this.head : this.tail.get(index - 1);
    }

    @Override
    public int size() {
        return this.tail.size() + 1;
    }

    @Override
    public boolean hasMultipleElements() {
        return !this.tail.isEmpty();
    }
}

