/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.collection;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class BatchedIterable<T, BATCH extends Iterable<? extends T>>
implements Iterable<T> {
    private Supplier<BATCH> batchFetcher;
    private Predicate<? super BATCH> canFetchNextBatch;

    public static <T, BATCH extends Iterable<? extends T>> Iterable<T> batched(Supplier<BATCH> batchFetcher, Predicate<? super BATCH> fetchNextBatch) {
        return new BatchedIterable<T, BATCH>(batchFetcher, fetchNextBatch);
    }

    private BatchedIterable(Supplier<BATCH> batchFetcher, Predicate<? super BATCH> fetchNextBatch) {
        this.batchFetcher = batchFetcher;
        this.canFetchNextBatch = fetchNextBatch;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            BATCH currentBatch;
            Iterator<? extends T> currentIterator;
            {
                this.currentBatch = (Iterable)BatchedIterable.this.batchFetcher.get();
                this.currentIterator = this.currentBatch.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                if (BatchedIterable.this.canFetchNextBatch.test(this.currentBatch)) {
                    this.currentBatch = (Iterable)BatchedIterable.this.batchFetcher.get();
                    this.currentIterator = this.currentBatch.iterator();
                    return this.currentIterator.hasNext();
                }
                return false;
            }

            @Override
            public T next() {
                return this.currentIterator.next();
            }
        };
    }
}

