/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import no.digipost.concurrent.TargetState;

public final class CountDown
implements TargetState {
    private final AtomicLong count;

    public CountDown(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("negative count: " + count);
        }
        this.count = new AtomicLong(count);
    }

    @Override
    public boolean yet() {
        return this.count.getAndUpdate(i -> i > 0L ? i - 1L : i) == 0L;
    }

    public String toString() {
        return "count down currently at " + this.count.get();
    }
}

