/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.concurrent;

import java.time.Duration;

public abstract class Waiter {
    public abstract void doWait();

    Waiter() {
    }

    public static Waiter wait(Duration duration) {
        return Waiter.wait(duration, Waiter.class.getSimpleName());
    }

    public static Waiter wait(final Duration duration, final String waiterName) {
        return new Waiter(){

            @Override
            public void doWait() {
                try {
                    Thread.sleep(duration.toMillis());
                }
                catch (InterruptedException e) {
                    throw new WasInterrupted(waiterName + " was interrupted.", e);
                }
            }
        };
    }

    public static class WasInterrupted
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        protected WasInterrupted(String message, InterruptedException e) {
            super(message + " " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
    }
}

