/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.function;

import java.util.function.BiConsumer;
import no.digipost.DiggExceptions;

@FunctionalInterface
public interface ThrowingBiConsumer<T, U, X extends Throwable> {
    public void accept(T var1, U var2) throws X;

    default public BiConsumer<T, U> asUnchecked() {
        return (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw DiggExceptions.asUnchecked(e);
            }
        };
    }

    default public ThrowingBiConsumer<T, U, X> andThen(ThrowingBiConsumer<? super T, ? super U, ? extends X> after) {
        return (t, u) -> {
            this.accept(t, u);
            after.accept(t, u);
        };
    }
}

