/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import no.digipost.DiggBase;
import no.digipost.stream.EmptyResultIfEmptySourceCollector;
import no.digipost.stream.ToNonEmptyStreamFunction;

public class NonEmptyStream<T>
implements Stream<T> {
    private final Stream<T> completeStream;

    public static <T> NonEmptyStream<T> of(T singleElement) {
        return NonEmptyStream.of(singleElement, Stream.empty());
    }

    @SafeVarargs
    public static <T> NonEmptyStream<T> of(T firstElement, T ... remainingElements) {
        return NonEmptyStream.of(firstElement, Arrays.stream(remainingElements));
    }

    public static <T> NonEmptyStream<T> of(T firstElement, Stream<T> remainingElements) {
        return NonEmptyStream.of(() -> firstElement, remainingElements);
    }

    public static <T> NonEmptyStream<T> of(Supplier<? extends T> firstElement, Stream<T> remainingElements) {
        return new NonEmptyStream<T>(firstElement, remainingElements);
    }

    public static <T> NonEmptyStream<T> concat(NonEmptyStream<? extends T> a, Stream<? extends T> b) {
        return new NonEmptyStream<T>(Stream.concat(a, b));
    }

    public static <T> NonEmptyStream<T> concat(Stream<? extends T> a, NonEmptyStream<? extends T> b) {
        return new NonEmptyStream<T>(Stream.concat(a, b));
    }

    public static <T> NonEmptyStream<T> concat(NonEmptyStream<? extends T> a, NonEmptyStream<? extends T> b) {
        return new NonEmptyStream<T>(Stream.concat(a, b));
    }

    public static <T> NonEmptyStream<T> iterate(T seed, UnaryOperator<T> f) {
        return new NonEmptyStream<T>(Stream.iterate(seed, f));
    }

    public static <T> NonEmptyStream<T> generate(Supplier<T> s) {
        return new NonEmptyStream<T>(Stream.generate(s));
    }

    private NonEmptyStream(Supplier<? extends T> firstElement, Stream<T> remainingElements) {
        this(Stream.concat(Stream.generate(firstElement).limit(1L), remainingElements));
    }

    private NonEmptyStream(Stream<T> completeNonEmptyStream) {
        this.completeStream = completeNonEmptyStream;
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.completeStream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.completeStream.collect(collector);
    }

    @Override
    public <A, R> R collect(EmptyResultIfEmptySourceCollector<? super T, A, R> collector) {
        Collector generalCollector = (Collector)Collector.class.cast(collector);
        return (R)((Optional)this.collect(generalCollector)).orElseThrow(() -> new IllegalStateException("Unexpected empty stream using Collector of type " + DiggBase.friendlyName(collector.getClass())));
    }

    @Override
    public <R> NonEmptyStream<R> map(Function<? super T, ? extends R> mapper) {
        return new NonEmptyStream<R>(this.completeStream.map(mapper));
    }

    @Override
    public Iterator<T> iterator() {
        return this.completeStream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.completeStream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.completeStream.isParallel();
    }

    @Override
    public NonEmptyStream<T> sequential() {
        return this.isParallel() ? new NonEmptyStream<T>((Stream)this.completeStream.sequential()) : this;
    }

    @Override
    public NonEmptyStream<T> parallel() {
        return this.isParallel() ? this : new NonEmptyStream<T>((Stream)this.completeStream.parallel());
    }

    @Override
    public NonEmptyStream<T> unordered() {
        return new NonEmptyStream<T>((Stream)this.completeStream.unordered());
    }

    @Override
    public NonEmptyStream<T> onClose(Runnable closeHandler) {
        return new NonEmptyStream<T>((Stream)this.completeStream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.completeStream.close();
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.completeStream.filter(predicate);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.completeStream.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.completeStream.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.completeStream.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.completeStream.flatMap(mapper);
    }

    @Override
    public <R> NonEmptyStream<R> flatMap(ToNonEmptyStreamFunction<? super T, ? extends R> mapper) {
        return new NonEmptyStream(this.completeStream.flatMap(mapper));
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.completeStream.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.completeStream.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.completeStream.flatMapToDouble(mapper);
    }

    @Override
    public NonEmptyStream<T> distinct() {
        return new NonEmptyStream<T>(this.completeStream.distinct());
    }

    @Override
    public NonEmptyStream<T> sorted() {
        return new NonEmptyStream<T>(this.completeStream.sorted());
    }

    @Override
    public NonEmptyStream<T> sorted(Comparator<? super T> comparator) {
        return new NonEmptyStream<T>(this.completeStream.sorted(comparator));
    }

    @Override
    public NonEmptyStream<T> peek(Consumer<? super T> action) {
        return new NonEmptyStream<T>(this.completeStream.peek(action));
    }

    public NonEmptyStream<T> limitToNonEmpty(long maxSizeMoreThanZero) {
        if (maxSizeMoreThanZero < 1L) {
            throw new IllegalArgumentException("Can not limit to " + maxSizeMoreThanZero + " and still be a non-empty stream");
        }
        return new NonEmptyStream<T>(this.limit(maxSizeMoreThanZero));
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.completeStream.limit(maxSize);
    }

    @Override
    public Stream<T> skip(long n) {
        return this.completeStream.skip(n);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.completeStream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.completeStream.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.completeStream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.completeStream.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.completeStream.reduce(identity, accumulator);
    }

    public T reduceFromFirst(BinaryOperator<T> accumulator) {
        return this.reduce(accumulator).orElseThrow(() -> new IllegalStateException("Unexpected empty stream"));
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.completeStream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.completeStream.reduce(identity, accumulator, combiner);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.completeStream.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.completeStream.max(comparator);
    }

    @Override
    public long count() {
        return this.completeStream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.completeStream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.completeStream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.completeStream.noneMatch(predicate);
    }

    public T first() {
        return this.findFirst().orElseThrow(() -> new IllegalStateException("Unexpected empty stream"));
    }

    @Override
    public Optional<T> findFirst() {
        return this.completeStream.findFirst();
    }

    public T any() {
        return this.findAny().orElseThrow(() -> new IllegalStateException("Unexpected empty stream"));
    }

    @Override
    public Optional<T> findAny() {
        return this.completeStream.findAny();
    }
}

